IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Clientes_Patente') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Clientes_Patente
END
GO

CREATE PROCEDURE [dbo].[CP_Clientes_Patente]		@pId_Cliente			INT,
												@pId_Cliente_Ref		INT,
												@pId_Cliente_Externo	VARCHAR(14),
												@pFlag_GrabaRegistro    TINYINT,
												@pId_Controlador		INT,
												@pTraerMax_Patente		TINYINT
												
AS

/*Declaracion Variables Locales*/
DECLARE @Mensaje				VARCHAR(100)
DECLARE @Flag_Existe_Patente	INT
DECLARE @Razon_Social			VARCHAR(100)
DECLARE @Id_Tipo_Doc			CHAR(3)
DECLARE @Ingresos_Brutos		VARCHAR(20)
DECLARE @Direccion				VARCHAR(100)
DECLARE @Cp						VARCHAR(10)
DECLARE @Id_Pais				CHAR(3)
DECLARE @Id_Provincia			CHAR(3)
DECLARE @Provincia_Descrip		VARCHAR(200)
DECLARE @Id_Localidad			INT
DECLARE @Localidad_Descrip		VARCHAR(200)
DECLARE @Fax					VARCHAR(8000)
DECLARE @Cuit					VARCHAR(13)
DECLARE @Email					VARCHAR(8000)
DECLARE @Activo					TINYINT
DECLARE @Id_Estado_Cliente		SMALLINT
DECLARE @Id_Grupo_Afinidad		SMALLINT
DECLARE @Porc_DescEspecial		DECIMAL(5, 2)
DECLARE @Id_Lista_Precio		SMALLINT
DECLARE @Id_Vendedor			VARCHAR(10)
DECLARE @Id_Transportista		VARCHAR(10)
DECLARE @Bonif					DECIMAL(5, 2)
DECLARE @Id_Cond_Pago			SMALLINT
DECLARE @Cred_CtaCte			DECIMAL(12, 2)
DECLARE @Cred_ChePro			DECIMAL(12, 2)
DECLARE @Cred_CheTer			DECIMAL(12, 2)
DECLARE @Id_Iva					CHAR(3)
DECLARE @CTE					VARCHAR(50)
DECLARE @Id_Concepto			INT
DECLARE @Id_Cta_Banco			SMALLINT
DECLARE @Id_Zona				CHAR(5) 
DECLARE @Observacion			VARCHAR(8000)
DECLARE @Id_Cliente_Externo		VARCHAR(14)
DECLARE @Id_Transporte			INT
DECLARE @Id_Alias_Cta_Cont_Venta SMALLINT
DECLARE @Mercado				CHAR(1)
DECLARE @Observa_Fact			VARCHAR(8000)
DECLARE @Entre_Calle_1			VARCHAR(35) 
DECLARE @Entre_Calle_2			VARCHAR(35) 
DECLARE @Plano_Nro				VARCHAR(10)
DECLARE @Plano_Matriz			VARCHAR(10)
DECLARE @Id_Cobrador			VARCHAR(10)
DECLARE @Id_Motivo_Est			SMALLINT
DECLARE @Id_Dep_Fisico			CHAR(3)
DECLARE @Id_Dep_Logico			CHAR(3)
DECLARE @Id_Tarjeta				VARCHAR(10)
DECLARE @Id_Banco				SMALLINT
DECLARE @Tar_Nro				VARCHAR(25) 
DECLARE @Tar_Fecha_Vence		DATETIME
DECLARE @Tar_Titular			VARCHAR(50)
DECLARE @Direccion_Cob			VARCHAR(100)
DECLARE @Cp_Cob					VARCHAR(10)
DECLARE @Id_Pais_Cob			CHAR(3)
DECLARE @Id_Provincia_Cob		CHAR(3)
DECLARE @Provincia_Descrip_Cob	VARCHAR(200)
DECLARE @Id_Localidad_Cob		INT
DECLARE @Localidad_Descrip_Cob	VARCHAR(200)
DECLARE @Entre_Calle_1_Cob		VARCHAR(35) 
DECLARE @Entre_Calle_2_Cob		VARCHAR(35) 
DECLARE @Plano_Nro_Cob			VARCHAR(10)
DECLARE @Plano_Matriz_Cob		VARCHAR(10)
DECLARE @Fecha_Ven_Trib			DATETIME
DECLARE @Web					VARCHAR(254)
DECLARE @Id_Cliente_Ref			INT
DECLARE @Fecha_Alta				DATETIME
DECLARE @Fecha_Baja				DATETIME
DECLARE @Id_Centro_Costo		CHAR(10)
DECLARE @Id_Promotor			CHAR(10)
DECLARE @Nombre_Fantasia		VARCHAR(100)
DECLARE @Id_Cond_Vta			CHAR(10)
DECLARE @Id_Puerto				CHAR(3)
DECLARE @Id_Calle				INT
DECLARE @Nro					INT
DECLARE @Depto					CHAR(10)	
DECLARE @Fecha_Modif			DATETIME
DECLARE @Foto					VARCHAR(254)
DECLARE @Latitud				DECIMAL(11, 7) 
DECLARE @Longitud				DECIMAL(11, 7) 
DECLARE @Id_Calle_Cob			INT
DECLARE @Nro_Cob				INT
DECLARE @Depto_Cob				VARCHAR(10)
DECLARE @Latitud_Cob			DECIMAL(11, 7) 
DECLARE @Longitud_Cob			DECIMAL(11, 7) 
DECLARE @Id_Precio_Especial		INT
DECLARE @Cod_Autoriz_Trib		VARCHAR(30)
DECLARE @Id_Alias_Cta_Cont_Venta_Dol SMALLINT
DECLARE @Estado_Civil			CHAR(1)
DECLARE @Id_Nacionalidad		CHAR(3)
DECLARE @Id_Cli_Relac			SMALLINT
DECLARE @Tipo_Persona			CHAR(1)
DECLARE @telefono				VARCHAR(900) 
DECLARE @Calle_Descrip			VARCHAR(100)
DECLARE @Calle_Cob_Descrip		VARCHAR(100)
DECLARE @Imp_Aporte				DECIMAL(12, 2)
DECLARE @Fecha_Aporte			DATETIME
DECLARE @Credencial_Banda1		VARCHAR(100)
DECLARE @Credencial_Banda2		VARCHAR(100)
DECLARE @Credencial_Imp			SMALLINT
DECLARE @Ult_Cuota_Paga			DATETIME
DECLARE @Legajo					VARCHAR(30)
DECLARE @Credencial_Entrega		DATETIME
DECLARE @Id_Unid_Negocio		CHAR(10)
DECLARE @Clave_Web				VARCHAR(30)
DECLARE @Flag_Anmat				TINYINT
DECLARE @Nro_Anmat				VARCHAR(26)
DECLARE @Tar_Cuit				VARCHAR(13)
DECLARE @Id_Anmat				CHAR(3)
DECLARE @Coef_Comi_Vta			DECIMAL(8, 4)
DECLARE @Coef_Comi_Cobros		DECIMAL(8, 4)
DECLARE @Email_Cob				VARCHAR(254)
DECLARE @Recorrido_Cob			INT
DECLARE @Tar_Fecha_Alta			DATETIME
DECLARE @Tar_Fecha_Baja			DATETIME
DECLARE @Imp_Fac_Max_Mes		DECIMAL(12, 2)
DECLARE @Email_Web				VARCHAR(300)
DECLARE @Tel_Movil				VARCHAR(20)
DECLARE @Flag_Tel_Movil_Verif	TINYINT
DECLARE @Flag_Comunic_Sms		TINYINT
DECLARE @Flag_Comunic_Email		TINYINT
DECLARE @Carpeta				VARCHAR(256)
DECLARE @Id_Emp_Area			SMALLINT
DECLARE @Id_AR_ARBA_COT_Tipo_Dom_Nro VARCHAR(5)
DECLARE @Dir_Entrega_Numero		SMALLINT
DECLARE @Dir_Entrega_Piso		VARCHAR(3)
DECLARE @Dir_Entrega_Dto		VARCHAR(4)
DECLARE @Dir_Entrega_Barrio		VARCHAR(30)
DECLARE @Dir_Entrega_CP			VARCHAR(8)
DECLARE @Dir_Entrega_Localidad	VARCHAR(50) 
DECLARE @Nombre					VARCHAR(100)
DECLARE @Apellido				VARCHAR(100)
DECLARE @Sexo					CHAR(1)
DECLARE @Fecha_Nac				DATETIME
DECLARE @Doc_Nro				BIGINT
DECLARE @Id_Tipo_Cli			SMALLINT
DECLARE @Credencial_Nro			VARCHAR(30)
DECLARE @Id_Usuario_Alta		SMALLINT
DECLARE @Max_Patente			VARCHAR(14)
DECLARE @Titular_GF				INT

DECLARE @CD_ES_Tipo				CHAR(1)
DECLARE @CD_ES_Origen			CHAR(1)
DECLARE @CD_ES_Id_Tarjeta		VARCHAR(50)
DECLARE @CD_ES_Fecha			DATETIME
DECLARE @CD_ES_Resultado		CHAR(1)
DECLARE @CD_ES_Id_Controlador	SMALLINT
DECLARE @CD_ES_Id_Acceso		SMALLINT
DECLARE @CD_ES_tipo_reg			CHAR(5) 
DECLARE @Usuario_Alta			VARCHAR(41)
DECLARE @Id_CD_Motivo			INT
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_Clientes_Patente'

IF(@pFlag_GrabaRegistro IS NULL)
BEGIN
	SET @pFlag_GrabaRegistro = 1 /*Por defecto graba el registro en CD_ES*/
END


IF EXISTS ( SELECT * 
			FROM sysobjects 
            WHERE
            id = object_id(N'[dbo].[CP_Clientes_Patente_]') 
			AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	EXEC CP_Clientes_Patente_	@pId_Cliente,
								@pId_Cliente_Ref,
								@pId_Cliente_Externo,
								@pFlag_GrabaRegistro,
								@pId_Controlador
	RETURN
END

BEGIN TRY
	BEGIN TRAN

	SET @Titular_GF = ISNULL((SELECT TOP 1 Id_Cliente_Ref FROM Clientes WHERE Id_Cliente_Ref = @pId_Cliente_Ref AND Activo = 1), 0)
	IF(@Titular_GF <> 0)
	BEGIN
		SET @pId_Cliente_Ref = @Titular_GF
	END

IF (@pTraerMax_Patente > 0)
BEGIN
	SET @Max_Patente = ISNULL((SELECT TOP 1 Id_Cliente_Externo FROM Clientes WHERE Id_Cliente_Ref = @pId_Cliente_Ref AND Tipo_Persona = 'A' order by Id_Cliente DESC), '')
	BEGIN
		SELECT	 0						AS ErrorNumber 
				,0						AS ErrorSeverity  
				,0						AS ErrorState 
				,0						AS ErrorProcedure  
				,0						AS ErrorLine		
				,@Mensaje				AS ErrorMessage
				,@Max_Patente			AS Id_Cliente
		ROLLBACK
		RETURN 1
	END

END
ELSE
BEGIN
	IF(@pId_Cliente > 0)
	BEGIN
		SET @Flag_Existe_Patente = @pId_Cliente
	END
	ELSE
	BEGIN
		IF(@pId_Cliente_Ref = '' OR @pId_Cliente_Externo = '')
			BEGIN
			SET @Mensaje = 'NO SE RECIBIERON CORRECTAMENTE TODOS LOS PARAMETROS'

			SELECT	 0				AS ErrorNumber 
			,0						AS ErrorSeverity  
			,0						AS ErrorState 
			,0						AS ErrorProcedure  
			,0						AS ErrorLine		
			,@Mensaje				AS ErrorMessage
			,0						AS Id_Cliente
						
			ROLLBACK
			RETURN 1
		END

	SET @Flag_Existe_Patente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Id_Cliente_Externo = @pId_Cliente_Externo), 0)
	END
	
	IF(@Flag_Existe_Patente = 0)
	BEGIN
		/*Asignacion de Variables*/
		SET @Nombre						= CONVERT(VARCHAR,@pId_Cliente_Ref)
		SET @Apellido					= CONVERT(VARCHAR,@pId_Cliente_Externo) + ' - '
		SET @Sexo						= ''
		SET @Fecha_Nac					= '19000101'
		SET @Doc_Nro					= 0
		SET @Id_Tipo_Cli				= 0
		SET @Credencial_Nro				= 0
		SET @Id_Usuario_Alta			= 0     --pasar por parametro
		SET @Id_Tipo_Doc				= ''	--Documentos_Tipos
		SET @Id_Localidad				= 0		--Tab_Localidades
		SET @Id_Provincia				= ''	--La del registro de Tab_Localidades
		SET @Id_Pais					= ''	--La del registro de Tab_Localidades
		SET @Activo						= 1
		SET @Id_Lista_Precio			= 0		--Prod_Listas_Precios
		SET @Id_Cond_Pago				= dbo.CF_xParam('SCA_Visitor_ConPago')
		SET @Id_Iva						= dbo.CF_xParam('SCA_Visitor_Iva')
		SET @Id_Concepto				= dbo.CF_xParam('SCA_Visitor_Concept')
		SET @Observacion				= 'Ingresado Automaticamente desde Proceso Patente'
		SET @Id_Alias_Cta_Cont_Venta	= dbo.CF_xParam('SCA_Visitor_AliasCV')
		SET @Mercado					= 'I'
		SET @Id_Cliente_Ref				= 0
		SET @Fecha_Alta					= GETDATE()
		SET @Id_Centro_Costo			= ''	--Centro_Costos
		SET @Id_Cond_Vta				= ''	--Cbtes_Cond_Vtas
		SET @Fecha_Modif				= @Fecha_Alta
		SET @Id_Alias_Cta_Cont_Venta_Dol = 0
		SET @Estado_Civil				= ''
		SET @Id_Nacionalidad			= ''	--Tab_Paises
		SET @Id_Cli_Relac				= 0		--Clientes_Relaciones
		SET @Tipo_Persona				= 'A'
		SET @Id_Unid_Negocio			= dbo.CF_xParam('SCA_Visitor_UNegoci')

		SET @CD_ES_Id_Tarjeta			= ''
		/*FIN Asignacion de Variables*/

		CREATE TABLE #RetornoSP
		(ErrorNumber INT,
		ErrorSeverity INT,
		ErrorState INT,
		ErrorProcedure INT,
		ErrorLine INT,
		ErrorMessage VARCHAR(200),
		Id_Cliente INT)

		/*INSERTO Clientes*/
		INSERT INTO #RetornoSP
		EXEC CP_Clientes_Insertar	@Razon_Social,
									@Apellido,
									@Nombre,
									@Sexo,
									@Fecha_Nac,
									@Id_Tipo_Doc,
									@Doc_Nro,
									@Ingresos_Brutos,
									@Direccion,
									@Cp,
									@Id_Pais,
									@Id_Provincia,
									@Provincia_Descrip,
									@Id_Localidad,
									@Localidad_Descrip,
									@Fax,
									@Cuit,
									@Email,
									@Activo,
									@Id_Estado_Cliente,
									@Id_Grupo_Afinidad,
									@Porc_DescEspecial,
									@Id_Lista_Precio,
									@Id_Vendedor,
									@Id_Transportista,
									@Bonif,
									@Id_Cond_Pago,
									@Cred_CtaCte,
									@Cred_ChePro,
									@Cred_CheTer,
									@Id_Iva,
									@CTE,
									@Id_Concepto,
									@Id_Cta_Banco,
									@Id_Zona,
									@Observacion,
									@pId_Cliente_Externo,
									@Id_Transporte,
									@Id_Alias_Cta_Cont_Venta,
									@Mercado,
									@Observa_Fact,
									@Entre_Calle_1 ,
									@Entre_Calle_2 ,
									@Plano_Nro,
									@Plano_Matriz,
									@Id_Cobrador,
									@Id_Motivo_Est,
									@Id_Tipo_Cli,
									@Id_Dep_Fisico,
									@Id_Dep_Logico,
									@Id_Tarjeta,
									@Id_Banco,
									@Tar_Nro ,
									@Tar_Fecha_Vence,
									@Tar_Titular,
									@Direccion_Cob,
									@Cp_Cob,
									@Id_Pais_Cob,
									@Id_Provincia_Cob,
									@Provincia_Descrip_Cob,
									@Id_Localidad_Cob,
									@Localidad_Descrip_Cob,
									@Entre_Calle_1_Cob ,
									@Entre_Calle_2_Cob ,
									@Plano_Nro_Cob,
									@Plano_Matriz_Cob,
									@Fecha_Ven_Trib,
									@Web,
									@pId_Cliente_Ref,
									@Fecha_Alta,
									@Fecha_Baja,
									@Id_Centro_Costo,
									@Id_Promotor,
									@Nombre_Fantasia,
									@Id_Cond_Vta,
									@Id_Puerto,
									@Id_Calle,
									@Nro,
									@Depto,
									@Fecha_Modif,
									@Foto,
									@Latitud ,
									@Longitud ,
									@Id_Calle_Cob,
									@Nro_Cob,
									@Depto_Cob,
									@Latitud_Cob ,
									@Longitud_Cob ,
									@Id_Precio_Especial,
									@Cod_Autoriz_Trib,
									@Id_Alias_Cta_Cont_Venta_Dol,
									@Estado_Civil,
									@Id_Nacionalidad,
									@Id_Cli_Relac,
									@Tipo_Persona,
									@telefono ,
									@Calle_Descrip,
									@Calle_Cob_Descrip,
									@Imp_Aporte,
									@Fecha_Aporte,
									@Credencial_Nro,
									@Credencial_Banda1,
									@Credencial_Banda2,
									@Credencial_Imp,
									@Ult_Cuota_Paga,
									@Legajo,
									@Credencial_Entrega,
									@Id_Unid_Negocio,
									@Clave_Web,
									@Flag_Anmat,
									@Nro_Anmat,
									@Tar_Cuit,
									@Id_Anmat,
									@Coef_Comi_Vta,
									@Coef_Comi_Cobros,
									@Email_Cob,
									@Recorrido_Cob,
									@Tar_Fecha_Alta,
									@Tar_Fecha_Baja,
									@Imp_Fac_Max_Mes,
									@Email_Web,
									@Tel_Movil,
									@Flag_Tel_Movil_Verif,
									@Flag_Comunic_Sms,
									@Flag_Comunic_Email,
									@Carpeta,
									@Id_Emp_Area,
									@Id_AR_ARBA_COT_Tipo_Dom_Nro,
									@Dir_Entrega_Numero,
									@Dir_Entrega_Piso,
									@Dir_Entrega_Dto,
									@Dir_Entrega_Barrio,
									@Dir_Entrega_CP,
									@Dir_Entrega_Localidad,
									@Id_Usuario_Alta									

		SET @Flag_Existe_Patente = (SELECT Id_Cliente FROM #RetornoSP)
	END
	ELSE
	BEGIN
		SET @Mensaje = 'EXISTE'
	END

	IF(@pFlag_GrabaRegistro = 1)
	BEGIN
		SET @CD_ES_Tipo				= 'E' --Entrada
		SET @CD_ES_Origen			= 'M' --Manual
		SET @CD_ES_Id_Tarjeta		= (SELECT ISNULL(Credencial_Nro, '') FROM Clientes WHERE Id_Cliente = @pId_Cliente_Ref)
		SET @CD_ES_Fecha			= GETDATE()
		SET @CD_ES_Resultado		= 'S'

		SET @Id_CD_Motivo			= 0
		SET @Usuario_Alta			= 0

		IF(ISNULL(@pId_Controlador, 0) = 0)
		BEGIN
			SET @CD_ES_Id_Controlador	= dbo.CF_xParam('SCA_Id_Contr_Vis') --CD_Controladores
		END
		ELSE
		BEGIN
			SET @CD_ES_Id_Controlador	= @pId_Controlador --CD_Controladores
		END

		SET @CD_ES_Id_Acceso		= (SELECT Id_Acceso FROM CD_Controladores WHERE Id_Controlador = @CD_ES_Id_Controlador)
		SET @CD_ES_tipo_reg			= ''

		/*INSERTO CD_ES*/
		INSERT INTO CD_ES
		(Tipo,			Origen,			Id_Tarjeta,
		Id_Cliente,		Fecha,			Resultado,
		Id_Controlador, Id_Acceso,		Observacion,
		tipo_reg,		Id_CD_Motivo,	Flag_Permite_Paso)
		VALUES
		(@CD_ES_Tipo,				@CD_ES_Origen,		@CD_ES_Id_Tarjeta,
		@Flag_Existe_Patente,		@CD_ES_Fecha,		@CD_ES_Resultado,
		@CD_ES_Id_Controlador,		@CD_ES_Id_Acceso,	'ALTA AUTOMOTOR',
		@CD_ES_tipo_reg,			@Id_CD_Motivo,		0)
	END
	
	COMMIT
	SELECT	 0						AS ErrorNumber 
			,0						AS ErrorSeverity  
			,0						AS ErrorState 
			,0						AS ErrorProcedure  
			,0						AS ErrorLine		
			,@Mensaje				AS ErrorMessage
			,@Flag_Existe_Patente   AS Id_Cliente

END
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH   


/*
EXEC [CP_Clientes_Patente] 0,8783,'ACLQ124',1,22,0
*/